<?php require_once __DIR__ . '/config.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Renewals & Payments</title>
  <link rel="stylesheet" href="styles.css">
  <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
</head>
<body>
  <div class="container">
    <h1>Renewals & Payments</h1>

    <section class="card">
      <h2>Find Customer</h2>
      <div class="row">
        <label>Customer ID</label>
        <input id="customer_id" placeholder="e.g. CUST001">
      </div>
      <div class="row">
        <label>Mobile</label>
        <input id="mobile" placeholder="e.g. 9876543210">
      </div>
      <button id="searchBtn">Search</button>
      <div id="customerInfo" class="info"></div>
    </section>

    <section class="card" id="productsSection" style="display:none;">
      <h2>Products</h2>
      <table id="productsTable">
        <thead>
          <tr>
            <th>Product</th><th>Base Price (₹)</th><th>Renew Date</th><th>Interest/Day (₹)</th><th>Action</th>
          </tr>
        </thead>
        <tbody></tbody>
      </table>
    </section>

    <section class="card" id="amountSection" style="display:none;">
      <h2>Amount Details</h2>
      <div id="amountDetails"></div>
      <div class="row">
        <label>Payment Term</label>
        <select id="termSelect">
          <option value="30">30 days</option>
          <option value="60">60 days</option>
          <option value="90">90 days</option>
          <option value="365">365 days</option>
        </select>
      </div>
      <button id="payBtn">Pay with Razorpay (Test)</button>
    </section>
  </div>

<script>
let selectedProduct = null;
let calcPayload = null;

document.getElementById('searchBtn').addEventListener('click', async () => {
  const customer_id = document.getElementById('customer_id').value.trim();
  const mobile = document.getElementById('mobile').value.trim();
  if (!customer_id || !mobile) {
    alert('Enter both Customer ID and Mobile.');
    return;
  }
  const res = await fetch('fetch_products.php', {
    method: 'POST',
    headers: {'Content-Type':'application/json'},
    body: JSON.stringify({ customer_id, mobile })
  });
  const data = await res.json();
  const info = document.getElementById('customerInfo');
  const table = document.getElementById('productsTable').querySelector('tbody');

  if (!data.ok) {
    info.innerHTML = '<span class="error">'+(data.message||'Not found')+'</span>';
    document.getElementById('productsSection').style.display='none';
    document.getElementById('amountSection').style.display='none';
    return;
  }

  info.innerHTML = `
    <div><strong>Name:</strong> ${data.customer.name}</div>
    <div><strong>Email:</strong> ${data.customer.email||'-'}</div>
    <div><strong>PAN:</strong> ${data.customer.pan||'-'}</div>
    <div><strong>Aadhar:</strong> ${data.customer.aadhar||'-'}</div>
    <div><strong>Address:</strong> ${data.customer.address||'-'}</div>
  `;

  table.innerHTML='';
  data.products.forEach(p => {
    const tr = document.createElement('tr');
    tr.innerHTML = `
      <td>${p.product_name} <small>(${p.product_id})</small></td>
      <td>${parseFloat(p.base_price).toFixed(2)}</td>
      <td>${p.renew_date}</td>
      <td>${parseFloat(p.interest_per_day).toFixed(2)}</td>
      <td><button class="calcBtn" data-id="${p.product_id}">Calculate</button></td>
    `;
    table.appendChild(tr);
  });
  document.getElementById('productsSection').style.display='block';

  document.querySelectorAll('.calcBtn').forEach(btn => {
    btn.addEventListener('click', async (e) => {
      const product_id = e.target.getAttribute('data-id');
      const r = await fetch('calculate_amount.php', {
        method:'POST',
        headers: {'Content-Type':'application/json'},
        body: JSON.stringify({ product_id })
      });
      const d = await r.json();
      if (!d.ok) { alert(d.message||'Calc error'); return; }
      selectedProduct = d.product;
      calcPayload = d;
      document.getElementById('termSelect').value = selectedProduct.payment_term_days;

      const a = d.amounts;
      document.getElementById('amountDetails').innerHTML = `
        <div><strong>Product:</strong> ${selectedProduct.product_name} (${selectedProduct.product_id})</div>
        <div><strong>Base:</strong> ₹${a.base.toFixed(2)}</div>
        <div><strong>GST 18%:</strong> ₹${a.gst.toFixed(2)} (CGST 9%: ₹${a.cgst.toFixed(2)}, SGST 9%: ₹${a.sgst.toFixed(2)})</div>
        <div><strong>Interest:</strong> ₹${a.interest.toFixed(2)}</div>
        <div class="total"><strong>Total Payable:</strong> ₹${a.total.toFixed(2)}</div>
        <hr>
        <div><em>Renew Date:</em> ${selectedProduct.renew_date} &nbsp; | &nbsp; <em>Today:</em> ${d.today}</div>
        <div><em>Overdue Days:</em> ${d.overdue_days}</div>
      `;
      document.getElementById('amountSection').style.display='block';
    });
  });
});

document.getElementById('payBtn').addEventListener('click', async () => {
  if (!calcPayload || !selectedProduct) return;

  const chosen_term = parseInt(document.getElementById('termSelect').value, 10);
  const res = await fetch('create_order.php', {
    method:'POST',
    headers:{'Content-Type':'application/json'},
    body: JSON.stringify({
      product_id: selectedProduct.product_id,
      total_amount: calcPayload.amounts.total, // rupees
      customer_id: selectedProduct.customer_id,
      chosen_term_days: chosen_term
    })
  });
  const data = await res.json();
  if (!data.ok) { alert(data.message||'Order error'); return; }

  const options = {
    key: data.key_id,
    amount: data.amount_paise,
    currency: "INR",
    name: "Renewals Demo",
    description: `Payment for ${selectedProduct.product_name}`,
    order_id: data.order_id,
    prefill: {
      name: calcPayload.customer.name || "",
      email: calcPayload.customer.email || "",
      contact: calcPayload.customer.mobile || ""
    },
    handler: async function (response){
      const verifyRes = await fetch('verify_payment.php', {
        method:'POST',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify({
          razorpay_payment_id: response.razorpay_payment_id,
          razorpay_order_id: response.razorpay_order_id,
          razorpay_signature: response.razorpay_signature,
          product_id: selectedProduct.product_id,
          chosen_term_days: chosen_term
        })
      });
      const verifyData = await verifyRes.json();
      if (verifyData.ok) {
        alert('Payment successful and renew date updated to ' + verifyData.new_renew_date);
        location.reload();
      } else {
        alert('Payment verification failed: ' + (verifyData.message||'Error'));
      }
    },
    theme: { color: "#3b82f6" }
  };

  const rzp = new Razorpay(options);
  rzp.on('payment.failed', function () { alert('Payment failed'); });
  rzp.open();
});
</script>
</body>
</html>
