<?php
require_once __DIR__ . '/config.php';
$input = json_decode(file_get_contents('php://input'), true);

$customer_id = trim($input['customer_id'] ?? '');
$mobile = trim($input['mobile'] ?? '');

if ($customer_id === '' || $mobile === '') {
  echo json_encode(['ok'=>false, 'message'=>'Missing customer_id or mobile']); exit;
}

$stmt = $pdo->prepare("SELECT * FROM customers WHERE customer_id=? AND mobile=? LIMIT 1");
$stmt->execute([$customer_id, $mobile]);
$customer = $stmt->fetch();

if (!$customer) { echo json_encode(['ok'=>false,'message'=>'Customer not found']); exit; }

$stmt = $pdo->prepare("SELECT * FROM products WHERE customer_id=? ORDER BY product_id");
$stmt->execute([$customer_id]);
$products = $stmt->fetchAll();

echo json_encode(['ok'=>true, 'customer'=>$customer, 'products'=>$products]);
