<?php
require_once __DIR__ . '/config.php';
$in = json_decode(file_get_contents('php://input'), true);

$product_id = trim($in['product_id'] ?? '');
$total_amount_rupees = (float)($in['total_amount'] ?? 0);
$customer_id = trim($in['customer_id'] ?? '');
$chosen_term_days = (int)($in['chosen_term_days'] ?? 30);

if ($product_id==='' || $total_amount_rupees<=0) {
  echo json_encode(['ok'=>false,'message'=>'Invalid order details']); exit;
}

$amount_paise = (int) round($total_amount_rupees * 100);

$orderPayload = [
  'amount' => $amount_paise,
  'currency' => 'INR',
  'receipt' => 'rcpt_'.time().'_'.$product_id,
  'payment_capture' => 1
];

// Create order with Razorpay REST
$ch = curl_init('https://api.razorpay.com/v1/orders');
curl_setopt($ch, CURLOPT_USERPWD, RAZORPAY_KEY_ID . ':' . RAZORPAY_KEY_SECRET);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($orderPayload));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$res = curl_exec($ch);
$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpcode !== 200 && $httpcode !== 201) {
  echo json_encode(['ok'=>false, 'message'=>'Razorpay order create failed', 'debug'=>$res]); exit;
}

$order = json_decode($res, true);

session_start();
$_SESSION['pending_payment'] = [
  'product_id'=>$product_id,
  'customer_id'=>$customer_id,
  'term_days'=>$chosen_term_days,
  'amount_rupees'=>$total_amount_rupees,
  'order_id'=>$order['id']
];

echo json_encode([
  'ok'=>true,
  'key_id'=>RAZORPAY_KEY_ID,
  'order_id'=>$order['id'],
  'amount_paise'=>$amount_paise
]);
