<?php
// api/hotels.php
declare(strict_types=1);
header('Content-Type: application/json');

// Allow local development use from file or same host
header('Access-Control-Allow-Origin: *');

require_once __DIR__ . '/../config/db.php';

$allowedFields = [
  'exp_dt_trade_license',
  'exp_dt_food_license',
  'exp_dt_fire_license',
  'tax_payment_upto',
];

$field = $_GET['field'] ?? '';
$range = $_GET['range'] ?? '';
$from  = $_GET['from']  ?? '';
$to    = $_GET['to']    ?? '';

if (!in_array($field, $allowedFields, true)) {
  http_response_code(400);
  echo json_encode(['error' => 'Invalid field']);
  exit;
}

// Build SQL
$sql = "";
$params = [];

if ($range === '3m' || $range === '6m') {
  $months = $range === '3m' ? 3 : 6;
  // Let MySQL do date math using CURDATE()
  $sql = "
    SELECT *
    FROM hotel_location_details
    WHERE $field BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL $months MONTH)
    ORDER BY $field
  ";
} elseif ($from !== '' && $to !== '') {
  // validate format YYYY-MM-DD simply
  $re = '/^\d{4}-\d{2}-\d{2}$/';
  if (!preg_match($re, $from) || !preg_match($re, $to)) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid date format']);
    exit;
  }
  $sql = "SELECT * FROM hotel_location_details WHERE $field BETWEEN :from AND :to ORDER BY $field";
  $params = [':from' => $from, ':to' => $to];
} else {
  // default: show next 12 months
  $sql = "
    SELECT *
    FROM hotel_location_details
    WHERE $field BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 12 MONTH)
    ORDER BY $field
  ";
}

try {
  $stmt = $pdo->prepare($sql);
  $stmt->execute($params);
  $rows = $stmt->fetchAll();

  echo json_encode($rows);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['error' => 'Query failed', 'detail' => $e->getMessage()]);
}
